package cn.eciot.ble_demo_java;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.util.Log;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;

public class TCPService extends Service {
    private static final String TAG = "TCPService";

    public static Socket socket;
    public static PrintStream output;
    private Thread connectionThread;
    private volatile boolean running = false; // 标志位控制线程
    private String ip = "10.10.100.254";
    private String port = "8089";
    private int recDtaLength = 128;

    @Override
    public IBinder onBind(Intent intent) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        ip = intent.getStringExtra("ipaddress");
        port = intent.getStringExtra("port");
        Log.d(TAG, "TCPService started. IP: " + ip + ", Port: " + port);

        running = true;
        connectionThread = new Thread(new MyThread());
        connectionThread.start();

        return START_STICKY; // 确保服务在意外终止时能够重启
    }

    @Override
    public void onDestroy() {
        super.onDestroy();

        // 停止线程
        running = false;
        if (connectionThread != null && connectionThread.isAlive()) {
            try {
                connectionThread.join(); // 等待线程结束
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        // 关闭资源
        try {
            if (output != null) {
                output.close();
            }
            if (socket != null && !socket.isClosed()) {
                socket.close();
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        Log.d(TAG, "TCPService destroyed, resources released.");
    }

    // Socket连接线程
    private class MyThread implements Runnable {
        @Override
        public void run() {
            try {
                socket = new Socket();
                SocketAddress socAddress = new InetSocketAddress(ip, Integer.parseInt(port));
                socket.connect(socAddress, 5000);

                InputStream inputStream = socket.getInputStream();
                output = new PrintStream(socket.getOutputStream(), true, "utf-8");
                byte[] buffer = new byte[recDtaLength];

                while (running) {
                    // 检查是否有数据可读
                    if (inputStream.available() > 0) {
                        int len = inputStream.read(buffer);
                        if (len > 0) {
                            String receiveData = new String(buffer, 0, len);
                            Intent CMDintent = new Intent();
                            CMDintent.setAction("com.example.communication.data");
                            CMDintent.putExtra("data", receiveData);
                            sendBroadcast(CMDintent);
                        }
                    }
                }
            } catch (IOException e) {
                Log.e(TAG, "Connection error: " + e.getMessage(), e);
            } finally {
                // 释放资源
                try {
                    if (output != null) {
                        output.close();
                    }
                    if (socket != null && !socket.isClosed()) {
                        socket.close();
                    }
                } catch (IOException e) {
                    Log.e(TAG, "Error closing resources: " + e.getMessage(), e);
                }
            }
        }
    }

    // 发送数据
    public static void send(final byte[] arr) {
        new Thread(() -> {
            if (socket != null && socket.isConnected()) {
                try {
                    output.write(arr);
                } catch (IOException e) {
                    Log.e(TAG, "Error sending data: " + e.getMessage(), e);
                }
            } else {
                Log.e(TAG, "Socket is not connected.");
            }
        }).start();
    }
}
