package cn.eciot.ble_demo_java;

import android.content.Context;
import android.content.SharedPreferences;

public class PreferenceManagerHelper {
    private static final String PREFS_NAME = "DeviceActivityPrefs";
    private static final String KEY_RECEIVED_DATA = "received_data";

    /**
     * 保存接收到的数据到 SharedPreferences
     *
     * @param context 上下文
     * @param data    要保存的数据
     */
    public static void saveReceivedData(Context context, String data) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREFS_NAME, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(KEY_RECEIVED_DATA, data);
        editor.apply(); // 异步保存
    }

    /**
     * 从 SharedPreferences 加载接收到的数据
     *
     * @param context 上下文
     * @return 加载的数据，如果没有则返回空字符串
     */
    public static String loadReceivedData(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREFS_NAME, Context.MODE_PRIVATE);
        return sharedPreferences.getString(KEY_RECEIVED_DATA, ""); // 默认返回空字符串
    }

    /**
     * 清除保存的数据
     *
     * @param context 上下文
     */
    public static void clearReceivedData(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREFS_NAME, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.remove(KEY_RECEIVED_DATA);
        editor.apply(); // 异步保存
    }
}
