package cn.eciot.ble_demo_java;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;

import java.nio.charset.StandardCharsets;
import java.util.Calendar;

import android.os.Vibrator;
import android.content.Context;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;

import java.util.Date;
import java.util.regex.Pattern;
import java.text.SimpleDateFormat;

public class MainActivity extends AppCompatActivity {

    /***************************************自定义对象**************************************************/
    String ipaddress="192.168.0.1";
    String port="8080";
    EditText editText_ipaddress;
    EditText editText_comnumber;
    TextView textView_status;
    private cmdReceiver cmdReceiver;
    /*****************************************  onCreate  *********************************************/
    @SuppressLint("SetTextI18n")
    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        /**对象实例化**/
        editText_ipaddress = findViewById(R.id.editText_ipaddress);     //IP  Edit
        editText_comnumber = findViewById(R.id.editText_comnumber);     //COM Edit
        textView_status = findViewById(R.id.textView_status);           //Status view
        /**按钮监听回调**/
        findViewById(R.id.imageButton_end).setOnClickListener((View view)->{
            System.out.println("程序关闭");
            finish();
        });
        findViewById(R.id.imageButton_link).setOnClickListener((View view)->{
            ipaddress = editText_ipaddress.getText().toString();
            port = editText_comnumber.getText().toString();
            textView_status.setText("IP地址："+ipaddress+"，端口号："+port+"正在连接。。。");
            ///开始连接新的TCP
            Intent mIntent = new Intent(this, TCPService.class);
            mIntent.putExtra("ipaddress", ipaddress);
            mIntent.putExtra("port", port);
            startService(mIntent);
        });
        /**注册广播接收器**/
        cmdReceiver = new cmdReceiver();    // 创建广播接收器
        IntentFilter intentFilter = new IntentFilter();     // 创建 IntentFilter，并添加需要接收的广播动作
        intentFilter.addAction("com.example.communication.data");
        registerReceiver(cmdReceiver, intentFilter);      // 注册广播接收器
    }

/*****************************************  成员方法  ******************************************/
    private class cmdReceiver extends BroadcastReceiver {
        @Override
        public void onReceive(Context context, Intent intent) {
            String recieveData = intent.getStringExtra("data");
            if(recieveData != null)
            {
                // 在成功跳转页面后取消注册 BroadcastReceiver
                unregisterReceiver(cmdReceiver.this);
                AlertDialog.Builder builder = new AlertDialog.Builder(MainActivity.this);
                builder.setTitle("提示");
                builder.setMessage("TCP连接成功！");
                builder.setPositiveButton("确定", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss(); // 关闭对话框
                        // 创建一个Intent对象，指定要启动的Activity类
                        Intent intentDevice = new Intent(MainActivity.this, DeviceActivity.class);
                        // 启动ActivityB
                        startActivity(intentDevice);
                    }
                });
                AlertDialog dialog = builder.create();
                dialog.show();
            }
        }
    }
}

