package cn.eciot.ble_demo_java;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ScrollView;
import android.widget.Switch;
import android.widget.TextView;
import android.widget.Toast;

import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.util.Calendar;

import android.os.Vibrator;
import android.content.Context;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;

import java.util.Date;
import java.util.regex.Pattern;
import java.text.SimpleDateFormat;
import android.graphics.Color;
public class DeviceActivity extends AppCompatActivity {
    String ipaddress = "192.168.0.1";
    String port = "8080";
    private int cnt, cnt1;
    private Thread newThread; //声明一个子线程

    /***************************************自定义对象**************************************************/
    EditText edit_1, edit_2, edit_3, edit_4, edit_5,edit_6;
    TextView tv_state, tv_val1, tv_val2, tv_val3, tv_val4, tv_val5;
    Switch sw_state;
    private DeviceActivity.cmdReceiver cmdReceiver;

    /*****************************************  onCreate  *********************************************/
    @SuppressLint("SetTextI18n")
    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_device);
        /**对象实例化**/
        tv_state = findViewById(R.id.tv_state);
        sw_state = findViewById(R.id.sw_state);
        tv_val1 = findViewById(R.id.tv_val1);
        tv_val2 = findViewById(R.id.tv_val2);
        tv_val3 = findViewById(R.id.tv_val3);
        tv_val4 = findViewById(R.id.tv_val4);


        edit_1 = findViewById(R.id.edit_1);
        edit_2 = findViewById(R.id.edit_2);
        edit_3 = findViewById(R.id.edit_3);
        edit_4 = findViewById(R.id.edit_4);
        edit_5 = findViewById(R.id.edit_5);
        edit_6 = findViewById(R.id.edit_6);
        /**按钮监听回调**/
        sw_state.setOnCheckedChangeListener((buttonView, isChecked) -> {
            Intent mIntent = new Intent(this, TCPService.class);
            mIntent.putExtra("ipaddress", ipaddress);
            mIntent.putExtra("port", port);
            if (isChecked) {
                tv_state.setText("连接");
                //连接TCP
                startService(mIntent);
            } else {
                tv_state.setText("断开");
                //断开TCP
                stopService(mIntent);
            }
        });

        findViewById(R.id.btn_11).setOnClickListener((View view) -> {
            String str = edit_1.getText().toString();
            String str1 = "AT+DATA1=" + str + ",\r\n";
            byte[] ByteArr1 = str1.getBytes(StandardCharsets.UTF_8);
            TCPService.send(ByteArr1);
        });
        findViewById(R.id.btn_12).setOnClickListener((View view) -> {
            String str = edit_2.getText().toString();
            String str1 = "AT+DATA2=" + str + ",\r\n";
            byte[] ByteArr1 = str1.getBytes(StandardCharsets.UTF_8);
            TCPService.send(ByteArr1);
        });
        findViewById(R.id.btn_13).setOnClickListener((View view) -> {
            String str = edit_3.getText().toString();
            String str1 = "AT+DATA3=" + str + ",\r\n";
            byte[] ByteArr1 = str1.getBytes(StandardCharsets.UTF_8);
            TCPService.send(ByteArr1);
        });
        findViewById(R.id.btn_14).setOnClickListener((View view) -> {
            String str = edit_4.getText().toString();
            String str1 = "AT+DATA4=" + str + ",\r\n";
            byte[] ByteArr1 = str1.getBytes(StandardCharsets.UTF_8);
            TCPService.send(ByteArr1);
        });
        findViewById(R.id.btn_15).setOnClickListener((View view) -> {
            String str = edit_5.getText().toString();
            String str1 = "AT+DATA5=" + str + ",\r\n";
            byte[] ByteArr1 = str1.getBytes(StandardCharsets.UTF_8);
            TCPService.send(ByteArr1);
        });
        findViewById(R.id.btn_16).setOnClickListener((View view) -> {
            String str = edit_6.getText().toString();
            String str1 = "AT+DATA6=" + str + ",\r\n";
            byte[] ByteArr1 = str1.getBytes(StandardCharsets.UTF_8);
            TCPService.send(ByteArr1);
        });


        /**自动更新时间线程**/

        /**接收数据处理**/
        /**注册广播接收器**/
        cmdReceiver = new DeviceActivity.cmdReceiver();    // 创建广播接收器
        IntentFilter intentFilter = new IntentFilter();     // 创建 IntentFilter，并添加需要接收的广播动作
        intentFilter.addAction("com.example.communication.data");
        registerReceiver(cmdReceiver, intentFilter);      // 注册广播接收器
    }


    /*****************************************  成员方法  ******************************************/
    private class cmdReceiver extends BroadcastReceiver {
        @Override
        public void onReceive(Context context, Intent intent) {
            String recieveData = intent.getStringExtra("data");
            if (recieveData != null) {
                if (recieveData.contains("=") != false && recieveData.contains(",") != false) {
                    String[] str_list = recieveData.split("[=,]");
                    tv_val1.setText(str_list[1]);
                    tv_val2.setText(str_list[2]);
                    tv_val3.setText(str_list[3]);
                    tv_val4.setText(str_list[4]);


                    if (!str_list[5].contains("0")) {
                        cnt++;
                        if (cnt == 1) {
                            if (str_list[5].contains("1")||str_list[5].contains("2"))
                                showDialog(DeviceActivity.this, "警告", "员工XXX当前体温异常!");
                            else if (str_list[5].contains("3"))
                                showDialog(DeviceActivity.this, "提醒", "员工XXX近期咳嗽频繁");
                            else if (str_list[5].contains("4")||str_list[5].contains("5"))
                                showDialog(DeviceActivity.this, "警告", "员工XXX心率异常");
                            else if (str_list[5].contains("6"))
                                showDialog(DeviceActivity.this, "警告", "员工XXX血氧饱和度过低");
                            else if (str_list[5].contains("7"))
                                showDialog(DeviceActivity.this, "警告", "检测到严重跌倒");
                            cnt++;
                        }
                    } else
                        cnt = 0;

                }
            }
        }
    }

    public void showDialog(Context context, String title, String message) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle(title);
        builder.setMessage(message);
        builder.setPositiveButton("确定", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                // 在这里定义确定按钮点击后的操作
                dialog.dismiss(); // 关闭弹窗
            }
        });
        builder.show();
    }
}
