/********************************************************************************
* @file		:jq8400.h
* @brief	:jq8400.c头文件
* @Author	:Gwen9
* @Date		:2024/08/05
* @Version	:V1.0 初始版本
*******************************************************************************/
#ifndef __JQ8400_H__
#define __JQ8400_H__

/* Public Macros  -------------------------------------------------------------------*/
#define JQ8400_BAUDRATE			9600   /*jq8400的串口波特率*/

/*JQ8400 默认工作参数*/
#define JQ8400_DEFAULT_DISK		JQ_DISK_FLASH		//盘符: FLASH
#define JQ8400_DEFAULT_MODE		JQ_MODE_ONE_STOP	//单次播放停止
#define JQ8400_DEFAULT_VOL		30					//默认音量20


/* Public Typedef  -------------------------------------------------------------------*/
typedef enum
{
	/*播放盘符选择*/
	JQ_DISK_U = 0,	
	JQ_DISK_SD,			
	JQ_DISK_FLASH,	
	
	/*播放控制*/
	JQ_CTRL_PLAY,			
	JQ_CTRL_PAUSE,
	JQ_CTRL_STOP,
	JQ_CTRL_LAST,
	JQ_CTRL_NEXT,
	JQ_CTRL_PLAY_SPECIFY,
	JQ_CTRL_LAST_DIR,
	JQ_CTRL_NEXT_DIR,
	JQ_CTRL_OVER,
	JQ_CTRL_REWIND,
	JQ_CTRL_FORWARD,

	/*播放模式*/
	JQ_MODE_ALL_LOOP,
	JQ_MODE_ONE_LOOP,
	JQ_MODE_ONE_STOP,
	JQ_MODE_RANDOM,
	JQ_MODE_DIR_LOOP,
	JQ_MODE_DIR_RANDOM,
	JQ_MODE_DIR_STOP,
	JQ_MODE_ORDER,

	/*播放音量*/
	JQ_VOL_ADD,
	JQ_VOL_SUB,
	JQ_VOL_SET,		

	/*系统信息: 需要使能接收, 否则只需要一个tx引脚即可*/
	JQ_INFO_STATE,

	JQ_ERROR,
}jq8400_cmd_t;

/** 
  * @brief JQ8400类，结构体定义 
  */
typedef struct _JQ8400 c_jq8400;
typedef struct _JQ8400
{
	/************************************************* 
    * Description: 空指针，指向该对象的私有成员
    *************************************************/  
    void* this;

	/************************************************* 
    * Description: JQ8400 语音播报模块
    * Input : <p_obj> JQ8400 对象;
	 		  <cmd> 需要发送的命令，分为多种命令类型，详见 jq8400_cmd_t;
			  <param> 参数，不带参数的命令直接填写 0 即可;
    * Return: <R_OK> 操作成功; <R_ERROR> 操作失败
    * Demo  : 
			ret = jq8400.send(&jq8400, JQ_DISK_FLASH, 0);		//设置 JQ8400 工作盘符为 FLASH  
			ret = jq8400.send(&jq8400, JQ_MODE_ONE_LOOP, 0);	//设置 JQ8400 工作模式为单曲循环模式
			ret = jq8400.send(&jq8400, JQ_VOL_SET, 31);			//设置 JQ8400 音量为31 最大

			ret = jq8400.send(&jq8400, JQ_CTRL_PLAY_SPECIFY, 1);// JQ8400 播放特定曲目 1
			ret = jq8400.send(&jq8400, JQ_CTRL_PAUSE, 0);		// JQ8400 暂停
			ret = jq8400.send(&jq8400, JQ_CTRL_PLAY, 0);		// JQ8400 继续
			ret = jq8400.send(&jq8400, JQ_CTRL_STOP, 0);		// JQ8400 停止播放

			ret = jq8400.send(&jq8400, JQ_CTRL_REWIND, 5);		// JQ8400 快退 5 秒 
			ret = jq8400.send(&jq8400, JQ_CTRL_FORWARD, 10);	// JQ8400 快进 10 秒 
    *************************************************/ 
	 int(*send)(const c_jq8400 *p_obj, jq8400_cmd_t cmd, uint16_t param);

}c_jq8400;


/************************************************* 
* Description: 创建一个 JQ8400 对象
* Input : <uart_id> 串口编号， MY_UART1 - MY_UART3;
* Return: JQ8400 对象
* Demo  : 
	c_jq8400 jq8400 = jq8400_create(MY_UART1);
*************************************************/ 
c_jq8400 jq8400_create(my_uart_id_t uart_id);


#endif 

