/********************************************************************************
* @file		:driver_conf.h
* @brief	:外部驱动层通用头文件，使能/失能各组件，方便裁剪
* @Author	:Gwen9
* @Date		:2024/08/05
* @Version	:V1.0 初始版本
*******************************************************************************/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __DRIVER_CONF_H
#define __DRIVER_CONF_H

#ifdef __cplusplus
 extern "C" {
#endif
 
/* Dependency file ------------------------------------------------------------*/
#include "onchip_conf.h"

/* Macros  -------------------------------------------------------------------*/
//User Driver Define
#define DRIVER_DS18B20_ENABLED
#define DRIVER_ESP8266_ENABLED
#define DRIVER_MAX30102_ENABLED
#define DRIVER_MPU6050_ENABLED
#define DRIVER_OLED_ENABLED

/* Typedef -------------------------------------------------------------------*/
/* Includes ------------------------------------------------------------------*/ 
/**
  * @brief Include module's header file
  */
#ifdef DRIVER_DS18B20_ENABLED
  #include "ds18b20.h" 
#endif 

#ifdef DRIVER_DHT11_ENABLED
  #include "dht11.h" 
#endif 

#ifdef DRIVER_HX711_ENABLED
  #include "hx711.h" 
#endif 

#ifdef DRIVER_HCSR04_ENABLED
  #include "hcsr04.h" 
#endif 

#ifdef DRIVER_DS1302_ENABLED
  #include "ds1302.h" 
#endif 

#ifdef DRIVER_STEPPER_ENABLED
  #include "stepper.h" 
#endif

#ifdef DRIVER_MATRIX_KEYPAD_ENABLED
  #include "matrix_keypad.h" 
#endif

#ifdef DRIVER_HX1838_ENABLED
  #include "hx1838.h" 
#endif 
/* P1 - PWM|ADC ----------------------*/ 
#ifdef DRIVER_CAR_ENABLED
#include "car.h" 
#endif 

#ifdef DRIVER_ADCDEVICE_ENABLED
#include "adcdevice.h" 
#endif 

#ifdef DRIVER_SERVO_ENABLED
  #include "servo.h" 
#endif 

#ifdef DRIVER_WS2812_ENABLED
  #include "ws2812.h" 
#endif 
/* P2 - UART ----------------------*/ 
#ifdef DRIVER_JQ8400_ENABLED
  #include "jq8400.h" 
#endif

#ifdef DRIVER_SIM800_ENABLED
  #include "sim800.h" 
#endif

#ifdef DRIVER_GPS_ENABLED
  #include "gps.h" 
#endif

#ifdef DRIVER_AS608_ENABLED
  #include "as608.h" 
#endif

#ifdef DRIVER_ESP8266_ENABLED
  #include "esp8266.h" 
#endif
/* P3 - IIC ----------------------*/   
#ifdef DRIVER_OLED_ENABLED
  #include "oled.h" 
#endif 

#ifdef DRIVER_MPU6050_ENABLED
  #include "mpu6050.h" 
#endif

#ifdef DRIVER_MAX30102_ENABLED
  #include "max30102.h" 
#endif

#ifdef DRIVER_BMP180_ENABLED
  #include "bmp180.h" 
#endif

#ifdef DRIVER_BH1750_ENABLED
  #include "bh1750.h" 
#endif

#ifdef DRIVER_SGP30_ENABLED
  #include "sgp30.h" 
#endif

#ifdef DRIVER_INA219_ENABLED
  #include "ina219.h" 
#endif

#ifdef DRIVER_TCS34725_ENABLED
  #include "tcs34725.h" 
#endif

#ifdef DRIVER_MLX90614_ENABLED
  #include "mlx90614.h" 
#endif 

/* P4 - SPI ----------------------*/ 
#ifdef DRIVER_RC522_ENABLED
  #include "rc522.h"
#endif

#ifdef DRIVER_LCD_ENABLED
  #include "lcd.h"
#endif
/* Macros --------------------------------------------------------------------*/
                               
#ifdef __cplusplus
}
#endif

#endif /* __ONCHIP_CONF_H */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/