/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file    stm32f1xx_it.c
  * @brief   Interrupt Service Routines.
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2024 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* USER CODE END Header */

/* Includes ------------------------------------------------------------------*/
#include "main.h"
#include "stm32f1xx_it.h"
#include "onchip_conf.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN TD */

/* USER CODE END TD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */

/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */

/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN PV */

/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
/* USER CODE BEGIN PFP */

/* USER CODE END PFP */

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */

/* USER CODE END 0 */

/* External variables --------------------------------------------------------*/

/* USER CODE BEGIN EV */

/* USER CODE END EV */

/******************************************************************************/
/*           Cortex-M3 Processor Interruption and Exception Handlers          */
/******************************************************************************/
/**
  * @brief This function handles Non maskable interrupt.
  */
void NMI_Handler(void)
{
  /* USER CODE BEGIN NonMaskableInt_IRQn 0 */

  /* USER CODE END NonMaskableInt_IRQn 0 */
  /* USER CODE BEGIN NonMaskableInt_IRQn 1 */
   while (1)
  {
  }
  /* USER CODE END NonMaskableInt_IRQn 1 */
}

/**
  * @brief This function handles Hard fault interrupt.
  */
void HardFault_Handler(void)
{
  /* USER CODE BEGIN HardFault_IRQn 0 */

  /* USER CODE END HardFault_IRQn 0 */
  while (1)
  {
    /* USER CODE BEGIN W1_HardFault_IRQn 0 */
    /* USER CODE END W1_HardFault_IRQn 0 */
  }
}

/**
  * @brief This function handles Memory management fault.
  */
void MemManage_Handler(void)
{
  /* USER CODE BEGIN MemoryManagement_IRQn 0 */

  /* USER CODE END MemoryManagement_IRQn 0 */
  while (1)
  {
    /* USER CODE BEGIN W1_MemoryManagement_IRQn 0 */
    /* USER CODE END W1_MemoryManagement_IRQn 0 */
  }
}

/**
  * @brief This function handles Prefetch fault, memory access fault.
  */
void BusFault_Handler(void)
{
  /* USER CODE BEGIN BusFault_IRQn 0 */

  /* USER CODE END BusFault_IRQn 0 */
  while (1)
  {
    /* USER CODE BEGIN W1_BusFault_IRQn 0 */
    /* USER CODE END W1_BusFault_IRQn 0 */
  }
}

/**
  * @brief This function handles Undefined instruction or illegal state.
  */
void UsageFault_Handler(void)
{
  /* USER CODE BEGIN UsageFault_IRQn 0 */

  /* USER CODE END UsageFault_IRQn 0 */
  while (1)
  {
    /* USER CODE BEGIN W1_UsageFault_IRQn 0 */
    /* USER CODE END W1_UsageFault_IRQn 0 */
  }
}

/**
  * @brief This function handles System service call via SWI instruction.
  */
void SVC_Handler(void)
{
  /* USER CODE BEGIN SVCall_IRQn 0 */

  /* USER CODE END SVCall_IRQn 0 */
  /* USER CODE BEGIN SVCall_IRQn 1 */

  /* USER CODE END SVCall_IRQn 1 */
}

/**
  * @brief This function handles Debug monitor.
  */
void DebugMon_Handler(void)
{
  /* USER CODE BEGIN DebugMonitor_IRQn 0 */

  /* USER CODE END DebugMonitor_IRQn 0 */
  /* USER CODE BEGIN DebugMonitor_IRQn 1 */

  /* USER CODE END DebugMonitor_IRQn 1 */
}

/**
  * @brief This function handles Pendable request for system service.
  */
void PendSV_Handler(void)
{
  /* USER CODE BEGIN PendSV_IRQn 0 */

  /* USER CODE END PendSV_IRQn 0 */
  /* USER CODE BEGIN PendSV_IRQn 1 */

  /* USER CODE END PendSV_IRQn 1 */
}

/**
  * @brief This function handles System tick timer.
  */
/* 	 72MHz ƵΪÿʱڵʱ = 1/72M = 13.89 ns

	Ӽ	ִʱ  13.89ns1 ʱڣ
	˷		ִʱ  13.89ns - 41.67ns1  3 ʱڣ
			ִʱ  27.78ns - 166.67ns2  12 ʱڣ

	Ӽ	 100  300 ʱΪ¹ʱΪ 1.39s - 4.17s
	˷		 200  500 ʱΪ¹ʱΪ 2.78s - 6.94s
			 500  1500 ʱΪ¹ʱΪ6.94s - 20.83s

	ARM Cortex-M3 ĺÿ ۺʱ㣺
	һ򵥵ĺҪ 4 ĴR0-R3ӼĴLRȻ󷵻أ
	ջʱ䣺PUSH {r0-r3, lr}  6 ʱ  83.34ns
	ջʱ䣺POP {r0-r3, pc}  6 ʱ  83.34ns
	תʱ䣺BX LR  1 ʱ  13.89ns
	ʱ䣺83.34nsջ + 83.34nsջ + 13.89nsת  180.57ns

	ʵӦУõʱ仹ܵصӰ죬磺
	ɵĴ룺ܻɶĴݡͻָĴ
	жϴںùзжϣжϷ (ISR) ִʱҲҪڡ
	ջʹЧʣʹŻĶջĴȣԼٺõĿ
*/
extern void HAL_SYSTICK_Callback(void);
void SysTick_Handler(void)
{
  /* USER CODE BEGIN SysTick_IRQn 0 */

  /* USER CODE END SysTick_IRQn 0 */
  HAL_IncTick();
  
  /* USER CODE BEGIN SysTick_IRQn 1 */
  HAL_SYSTICK_Callback();  //HALѶΪ __weak ͣ my_systick.c ʵ				
  /* USER CODE END SysTick_IRQn 1 */
}

/******************************************************************************/
/* STM32F1xx Peripheral Interrupt Handlers                                    */
/* Add here the Interrupt Handlers for the used peripherals.                  */
/* For the available peripheral interrupt handler names,                      */
/* please refer to the startup file (startup_stm32f1xx.s).                    */
/******************************************************************************/

/* USER CODE BEGIN 1 */
typedef struct
{
    void(*int_func)(dma_chn_num_t,void*);
    void*              param;
}dma_func_t;

static void m_dma_call_back(dma_chn_num_t dma_chn);

static dma_func_t dma_func_list[7];

void DMA1_Channel1_IRQHandler(void)
{
	m_dma_call_back(DMAChn1);
}

void DMA1_Channel2_IRQHandler(void)
{
	m_dma_call_back(DMAChn2);
}

void DMA1_Channel3_IRQHandler(void)
{
	m_dma_call_back(DMAChn3);
}

void DMA1_Channel4_IRQHandler(void)
{
	m_dma_call_back(DMAChn4);
}

void DMA1_Channel5_IRQHandler(void)
{
	m_dma_call_back(DMAChn5);
}

void DMA1_Channel6_IRQHandler(void)
{
	m_dma_call_back(DMAChn6);
}

void DMA1_Channel7_IRQHandler(void)
{
	m_dma_call_back(DMAChn7);
}

int it_register_dma(dma_chn_num_t dma_chn, void(*int_func)(dma_chn_num_t,void*), void* param)
{
	/**/
	if(NULL == int_func){
		return R_NULL;
	}
	
	/*ǷѾע*/
	if(NULL != dma_func_list[dma_chn].int_func){
		return R_ERROR; 
	}

	/*ע*/
	dma_func_list[dma_chn].int_func = int_func;
	dma_func_list[dma_chn].param = param;

	return R_OK;
}

static void m_dma_call_back(dma_chn_num_t dma_chn)
{
	/*ִжӦĻص*/
    if(NULL != dma_func_list[dma_chn].int_func){
        dma_func_list[dma_chn].int_func(dma_chn, dma_func_list[dma_chn].param);
    }
}

/* USER CODE END 1 */
