/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.c
  * @brief          : Main program body
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2024 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* USER CODE END Header */
/* Includes ------------------------------------------------------------------*/
#include "main.h"
#include "onchip_conf.h"
#include "driver_conf.h"

/* Private includes ----------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/

/* Private function prototypes -----------------------------------------------*/
void SystemClock_Config(void);

/* Private variables ---------------------------------------------------------*/
/*object*/
c_my_iic iic_oled;                      // oled õ iic ṹ
c_oled oled;                            // oled ṹ
c_esp8266 esp8266;  // esp8266 ṹ
c_ds18b20 ds18b20;                  // ds18b20 ṹ
c_my_iic iic_max30102;                      // max30102 õ iic ṹ
c_max30102 max30102;                        // max30102 ṹ
uint32_t red_buf[BUFFER_SIZE];				//ڻем
uint32_t ir_buf[BUFFER_SIZE];				//ڻем
c_my_iic iic_mpu6050;                       // mpu6050 õ iic ṹ
c_mpu6050 mpu6050;                          // mpu6050 ṹ
c_my_gpio beep;                 //  ƽṹ

/*variables*/
static float ds18b20_temp,temp;          //ڱ ds18b20 ȡ¶Ƚ
static uint32_t heartrate, o2;              //ڱ max30102 ȡ ʣѪŨ
static float angle[3];                      //ڱ mpu6050 ȡĽǶֵ
static uint8_t fall_flag = 0;				//־λ 0 1
const static uint8_t sw_cnt = 4;		//ҪõĲ
static uint8_t sw_set;					//ǰѡ
static int timer_id;              	//ʱID
static uint8_t data[8];				//ʱص
static float voice_lv;

static uint8_t page,page_flag=0,clear_flag,clear=0,long_flag;
static uint8_t beep_flag,error_flag;
static uint8_t voice_cnt,voice_flag;

static float temp_up=40,temp_down=15;
static uint8_t o2_down=70,voice_down=20;
static uint16_t heartrate_up=140,heartrate_down=80;
/*callback*/
int esp8266_recive_callback(void* parameter, char* key, char *value)
{
    /* WIFIģ ڽжϴ*/
	static char rec_buf[64];
	if(strlen(value) < 64){
		memset(rec_buf, 0, sizeof(rec_buf));
		memcpy(rec_buf, value, strlen(value));
	}
    char *pxIndex;

		if(strstr(rec_buf, "AT+DATA1") != NULL){  //¶
			sscanf(rec_buf, "AT+DATA1=%f,", &temp_up); //ʹ %d ʾ temp_downtemp_up 붨Ϊ int 
		}else if(strstr(rec_buf, "AT+DATA2") != NULL){  //¶
			sscanf(rec_buf, "AT+DATA2=%f,", &temp_down); //ʹ %d ʾ temp_downtemp_up 붨Ϊ int 
		}else if(strstr(rec_buf, "AT+DATA3") != NULL){ //¶
			sscanf(rec_buf, "AT+DATA3=%hhu,", &voice_down); //ʹ %f humi_down, humi_up 붨Ϊ float 
		}else if(strstr(rec_buf, "AT+DATA4") != NULL){ //¶
			sscanf(rec_buf, "AT+DATA4=%hu,", &heartrate_up); //ʹ %f humi_down, humi_up 붨Ϊ float 
		}else if(strstr(rec_buf, "AT+DATA5") != NULL){ //¶
			sscanf(rec_buf, "AT+DATA5=%hu,", &heartrate_down); //ʹ %f humi_down, humi_up 붨Ϊ float 
		}else if(strstr(rec_buf, "AT+DATA6") != NULL){ //¶
			sscanf(rec_buf, "AT+DATA6=%hu,", &o2_down); //ʹ %f humi_down, humi_up 붨Ϊ float 
		}

    return R_OK;
}
int my_exti_callback(const char* key_name, uint8_t key_state)
{
	if(strstr(key_name, "KEY1") != NULL && key_state == 1){
		if(!long_flag){
			if(page==0){
				
			}else if(page==1){
				if(sw_set == 0)		    temp_up    +=0.5;
				else if(sw_set == 1)	temp_down  +=0.5;		
				else if(sw_set == 2)  voice_down +=5  ;            					
			}else if(page==2){
				if(sw_set == 0)		    heartrate_up    +=5;
				else if(sw_set == 1)	heartrate_down  +=5;		
				else if(sw_set == 2)  o2_down         +=5;            			
			}			
		}
		long_flag = 0;
	}
	if(strstr(key_name, "KEY2") != NULL && key_state == 1){
		if(!long_flag){
			if(page==0){
				
			}else if(page==1){
				if(sw_set == 0)		    temp_up    -=0.5;
				else if(sw_set == 1)	temp_down  -=0.5;		
				else if(sw_set == 2)  voice_down -=5  ;            
			}else if(page==2){
				if(sw_set == 0)		    heartrate_up    -=5;
				else if(sw_set == 1)	heartrate_down  -=5;		
				else if(sw_set == 2)  o2_down         -=5;            			
			}			
		}
		long_flag = 0;
	}
	if(strstr(key_name, "KEY3") != NULL && key_state == 1){
		if(page==1){
			sw_set++;
			if(sw_set >= 3) sw_set = 0;		
		}else if(page==2){
			sw_set++;
			if(sw_set >= 3) sw_set = 0;					
		}
	}
	if(strstr(key_name, "KEY4") != NULL && key_state == 1){
		page_flag++;
		sw_set = 0;
		if(page_flag>=3){
			page_flag=0;
		}
	}
	return R_OK;
}
void timer_callback(void* param)
{
	static uint8_t a;
	static uint16_t cnt,v_cnt;
	
	v_cnt++;
	if(voice_flag==0){
		cnt++;
		if(cnt>=10){
			cnt=0;
			voice_flag=1;
		}
	}
	if(page==3&&error_flag==0){
		page_flag = 0;
	}
	
	if(v_cnt>=600){
		v_cnt=0;
		voice_cnt=0;
	}
		
	if(beep_flag==1){
//		a=!a;
//		led.set(&led, a);
		beep.set(&beep, !beep_flag);
		
//		cnt++;		
//		if(cnt>=10){
//			cnt=0;
//			beep_flag = 0;
//			led.set(&led, !beep_flag);
//			beep.set(&beep, !beep_flag);	
//		}
	}
//	my_systick.stop_timer(timer_id);         	//ָֹͣʱ
}
/* Private user code ---------------------------------------------------------*/
/**
  * @brief  The application entry point.
  * @retval int
  */
int main(void)
{
	/* Reset of all peripherals, Initializes the Flash interface and the Systick. */
	HAL_Init();
	/* Configure the system clock */
	SystemClock_Config();
	/* ???100ms ???????????? */
	DelayMs(100);

	/*init*/
	iic_oled = my_iic_create(GPIOA, GPIO_PIN_11, GPIOA, GPIO_PIN_12);	//ʼ iic
	oled = oled_create(&iic_oled);										//ʼOLEDʾ
	oled.clear(&oled);													//

	c_esp8266 esp8266 = esp8266_creat(MY_UART3, AP_TCP, "", "", "");        //TCPģʽʼ
	esp8266.set_recive_callback(&esp8266, esp8266_recive_callback, NULL);   //ýжϴ

	ds18b20 = ds18b20_create(GPIOA, GPIO_PIN_8);//ʼ ds18b20 ¶ȴ

	iic_max30102= my_iic_create(GPIOB, GPIO_PIN_12, GPIOB, GPIO_PIN_13);//ʼ iic
	max30102 = max30102_create(&iic_max30102, red_buf, ir_buf);  		//ʼ max30102 Ѫģ

	iic_mpu6050 = my_iic_create(GPIOB, GPIO_PIN_6, GPIOB, GPIO_PIN_7);  //ʼ iic
	mpu6050 = mpu6050_create(&iic_mpu6050);     //ʼ mpu6050 6ᴫ

	beep = my_gpio_create(GPIOB, GPIO_PIN_5, GPIO_OUT); //ʼ  õGPIO
	beep.set(&beep, 1);             // ؿ

	my_adc.init(ADC_CHANNEL_6);	
	
	exti_list_t exti_list[] = { //ⲿжб
		/*exti_list*/
		{"KEY1",GPIOC, GPIO_PIN_15, MY_EXTI_FALLING},    //1 ½شĬΪߵƽ
		{"KEY2",GPIOC, GPIO_PIN_14, MY_EXTI_FALLING},    //2 شĬΪ͵ƽ
		{"KEY3",GPIOC, GPIO_PIN_13, MY_EXTI_FALLING},    //3 ½شĬΪߵƽ
		{"KEY4",GPIOB, GPIO_PIN_4, MY_EXTI_FALLING},   	 //4 ½شĬΪߵƽ
	};
	my_exti.init(exti_list, sizeof(exti_list)/sizeof(exti_list_t), my_exti_callback);

	timer_id = my_systick.create_timer(100, timer_callback, (void*)data);		//һʱ

	my_systick.start_timer(timer_id);

	
	/*Infinite loop*/
	static uint32_t sys_cnt;
	while (1)
	{	
		if((sys_cnt%100) == 0){

			/*get demo*/
			ds18b20.get(&ds18b20, &ds18b20_temp);       //ȡһ¶Ƚ ds18b20_temp 
			if(ds18b20_temp<75){
				temp=ds18b20_temp;
			}
			max30102.get(&max30102, &heartrate, &o2);   //ȡһ ѪŨֵ浽heartrate  o2

			
			mpu6050.read_angle(&mpu6050, angle);        	//ȡһνǶֵ 浽angleУʾ X,Y,Z бǶ
			if(fabs(angle[0])>50 || fabs(angle[1])>50){		//xyбǶȹжΪ
				fall_flag=1;
			}
			else {
				fall_flag=0;
			}
			
			if(temp>temp_up){
				error_flag = 1;
			}else if(temp<temp_down){
				error_flag = 2;
			}else if(voice_cnt>voice_down){
				error_flag = 3;
			}else if(heartrate>heartrate_up){
				error_flag = 4;
			}else if(heartrate<heartrate_down&&heartrate>0){
				error_flag = 5;
			}else if(o2<o2_down&&o2>0){
				error_flag = 6;
			}else if(fall_flag){
				error_flag = 7;
			}else 
				error_flag = 0;
			
			
			if(error_flag){
				beep_flag = 1;
				page_flag = 3;
			}else {
				beep_flag = 0;
			}
			
			/*ctrl demo*/
			if(clear){
				clear=0;
				oled.clear(&oled);
			}
			if(page!=page_flag){
				page=page_flag;
				oled.clear(&oled);
			}
			if(page==0){
				oled.show(&oled, 0, 0, 16, ":%3dѪ:%2d", heartrate, o2);
				oled.show(&oled, 0, 2, 16, ":%.1f", temp);
				oled.show(&oled, 0, 4, 16, "Դ:%3d", voice_cnt);
				
			}else if(page==1){
				oled.show(&oled, 32, 0, 16, "ֵ");
				oled.show(&oled, 0, 2, 16, ":%.1f", temp_up      );
				oled.show(&oled, 0, 4, 16, ":%.1f", temp_down    );
				oled.show(&oled, 0, 6, 16, "Դ:%3d",    voice_down   );
				oled.show(&oled, 120, 2+sw_set*2, 16,"<");
				for(uint8_t i=0;i<4;i++){
					if(i!=sw_set)
						oled.show(&oled, 120, 2+i*2, 16," ");
				}
			}else if(page==2){
				oled.show(&oled, 32, 0, 16, "ֵ");
				oled.show(&oled, 0, 2, 16, ":%3d", heartrate_up      );
				oled.show(&oled, 0, 4, 16, ":%3d", heartrate_down    );
				oled.show(&oled, 0, 6, 16, "Ѫ:%3d ",  o2_down         );
				oled.show(&oled, 120, 2+sw_set*2, 16,"<");
				for(uint8_t i=0;i<4;i++){
					if(i!=sw_set)
						oled.show(&oled, 120, 2+i*2, 16," ");
				}
			}else if(page==3){
				if(error_flag==1||error_flag==2){
					oled.show(&oled, 32, 0, 16, "쳣");
					oled.show(&oled, 0, 2, 16, "ʹ¼ƽ");
					oled.show(&oled, 48, 4, 16, "ȷ");
				}else if(error_flag==3){
					oled.show(&oled, 32, 0, 16, "Ƶ");
					oled.show(&oled, 24, 2, 16, "עⱣů");
					oled.show(&oled, 32, 4, 16, "ˮ");
				}else if(error_flag==4||error_flag==5){
					oled.show(&oled, 32, 0, 16, "쳣");
					oled.show(&oled, 32, 2, 16, "Ϣ");
					oled.show(&oled, 24, 4, 16, "ʱҽ");
				}else if(error_flag==6){
					oled.show(&oled, 32, 0, 16, "Ѫ");
					oled.show(&oled, 24, 2, 16, "뵽ͨ紦");
					oled.show(&oled, 8, 4, 16, "֢״");
				}else if(error_flag==7){
					oled.show(&oled, 24, 0, 16, "⵽ˤ");
				}
			}
//			oled.show(&oled, 0, 0, 16, "temp:%.1f", temp);
//		oled.show(&oled, 0, 0, 16, "¶:%.1f", temp); //ʾֿת
		

			if(!beep_flag){
			//	led.set(&led, !beep_flag);
				beep.set(&beep, !beep_flag); 				
			}

			
			
		}
		if((sys_cnt%10) == 0){		
			my_adc.get(ADC_CHANNEL_6, &voice_lv); //ɼһ Һλ߶
			voice_lv = voice_lv *30.3; 
			
			if(voice_lv>15&&voice_flag==1){
				voice_cnt++;
				voice_flag = 0;
			}
		}
		if((sys_cnt%200) == 0){
			if(esp8266.state(&esp8266) == ESP8266_TCP_CONNECTED){
			    esp8266.send(&esp8266, "AT+DATA=%.1f,%d,%d,%d,%d,\r\n", temp, heartrate,o2,voice_cnt,error_flag);  //
			}
		}

		/*??????????????*/
		my_systick.period_task_running();
		sys_cnt++;
		HAL_Delay(1);
	}
}


/**
  * @brief System Clock Configuration
  * @retval None
  */
void SystemClock_Config(void)
{
  RCC_OscInitTypeDef RCC_OscInitStruct = {0};
  RCC_ClkInitTypeDef RCC_ClkInitStruct = {0};

  /** Initializes the RCC Oscillators according to the specified parameters
  * in the RCC_OscInitTypeDef structure.
  */
  RCC_OscInitStruct.OscillatorType 			= RCC_OSCILLATORTYPE_HSE;	
  RCC_OscInitStruct.HSEState 				= RCC_HSE_ON;				
  RCC_OscInitStruct.HSEPredivValue 			= RCC_HSE_PREDIV_DIV1;		
  RCC_OscInitStruct.HSIState				= RCC_HSI_ON;
  RCC_OscInitStruct.PLL.PLLState			= RCC_PLL_ON;				
  RCC_OscInitStruct.PLL.PLLSource			= RCC_PLLSOURCE_HSE;	
  RCC_OscInitStruct.PLL.PLLMUL				= RCC_PLL_MUL9;		
  if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK)
  {
    Error_Handler();
  }

  /** Initializes the CPU, AHB and APB buses clocks
  */
  RCC_ClkInitStruct.ClockType 		= RCC_CLOCKTYPE_HCLK|RCC_CLOCKTYPE_SYSCLK|RCC_CLOCKTYPE_PCLK1|RCC_CLOCKTYPE_PCLK2;
  RCC_ClkInitStruct.SYSCLKSource 	= RCC_SYSCLKSOURCE_PLLCLK;
  RCC_ClkInitStruct.AHBCLKDivider 	= RCC_SYSCLK_DIV1;
  RCC_ClkInitStruct.APB1CLKDivider 	= RCC_HCLK_DIV2;
  RCC_ClkInitStruct.APB2CLKDivider 	= RCC_HCLK_DIV1;

  if (HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_2) != HAL_OK)
  {
    Error_Handler();
  }
}

/**
  * @brief  This function is executed in case of error occurrence.
  * @retval None
  */
void Error_Handler(void)
{
  /* USER CODE BEGIN Error_Handler_Debug */
  /* User can add his own implementation to report the HAL error return state */
  __disable_irq();
  while (1)
  {
  }
  /* USER CODE END Error_Handler_Debug */
}